# ICO v5.1.8
**Release Date:** January 30, 2025
**Tags:** BUG FIXES, UI IMPROVEMENTS, ARCHITECTURE, DARK MODE

## Bug Fixes

### ICO Offer Creation
#### Token Type Validation
- **Fixed** "Invalid token type: Governance  A" error with extra spaces when creating offers
- **Fixed** Frontend sending token type value instead of ID causing validation failures
- **Resolved** Complex normalization issues by using proper UUID-based architecture

#### Admin Offer Detail Page
- **Fixed** Admin ICO offer detail page dark mode showing white background
- **Fixed** Hero section background showing white in dark mode (changed from primary gradient to slate gradient)
- **Fixed** All text colors using `text-background` (white) instead of theme-aware `text-primary-foreground`
- **Fixed** Stat boxes, badges, and progress bars not respecting dark mode
- **Fixed** Missing admin action buttons (approve, reject, pause, resume, flag) not visible on offer detail page
- **Fixed** Missing Check icon import in admin ICO detail page
- **Fixed** ESLint error with restricted import `useRouter` from 'next/navigation' instead of '@/i18n/routing'

#### Transaction Endpoint
- **Fixed** SQL error: Unknown column 'icoTokenOffering.id' (should be 'icoTransaction.offeringId')
- **Fixed** Transaction listing endpoint query with correct table alias reference

## UI/UX Improvements

### Admin Offer Detail Page
#### Dark Mode Support
- **Enhanced** Hero section with proper slate gradients for dark mode
- **Improved** All theme colors to respect light/dark mode properly
- **Added** Theme-aware colors for stat boxes, badges, progress bars
- **Fixed** Text visibility with `text-primary-foreground` throughout

#### Admin Actions
- **Added** Comprehensive Admin Actions card with all action buttons
- **Implemented** Approve/Reject buttons for pending offers
- **Added** Pause/Resume buttons for active offers
- **Included** Flag/Unflag functionality for moderation

#### Visual Consistency
- **Enhanced** Hero section layout and spacing
- **Improved** Card component styling for better readability
- **Added** Proper button grouping and spacing

## Technical Improvements

### Architecture Changes
#### Backend Validation
- **Simplified** Token type validation to only accept UUID format
- **Removed** 100+ lines of complex normalization code with multiple fallback strategies
- **Implemented** Consistent UUID validation across admin and user ICO creation endpoints
- **Added** Clear error messages for invalid UUID format

#### Frontend Changes
- **Updated** Token configuration step to send token type ID instead of value
- **Changed** SelectItem from `value={tokenType.value}` to `value={tokenType.id}`
- **Ensured** UUID is sent to backend instead of display value
- **Fixed** Import from correct i18n routing module

#### Code Quality
- **Removed** Complex token type normalization code
- **Simplified** Validation logic with direct UUID checking
- **Improved** Error handling and debugging

### SQL Query Fixes
- **Corrected** Table alias in transaction computed field query
- **Changed** Reference from `icoTokenOffering.id` to `icoTransaction.offeringId`
