# Version 5.4.5

**Release Date:** August 27, 2025  
**Tags:** BUG FIXES, PERFORMANCE IMPROVEMENTS, UI IMPROVEMENTS

## Fixed

### Support System
- **Admin Dashboard Display**: Fixed ticket visibility in Super Admin Dashboard with proper customer info
- **Data Columns**: Improved ticket data columns by removing expandedOnly restrictions
- **Customer Info**: Enhanced display by renaming "User" column to "Customer" for clarity
- **Information Visibility**: Fixed critical information visibility without requiring row expansion

### User Interface
- **Navigation Routing**: Fixed API Management navigation from `/user/api` to `/user/profile?tab=api`
- **Profile Integration**: Resolved profile page API integration to open as tab within user profile
- **Dropdown Links**: Corrected user dropdown link routing to prevent 404 errors

### Master Wallet Display
- **Balance Formatting**: Fixed balance precision to display 8 decimal places in admin panel
- **Font Styling**: Added monospace font styling for better number alignment in tables
- **High Precision**: Improved balance visibility for high-precision cryptocurrency amounts

## Improved

### Master Wallet Balance Updates
- **Parallel Processing**: Implemented processing with 3-second timeout per wallet
- **Non-blocking Operations**: Added fault tolerance preventing failed updates from blocking others
- **Query Optimization**: Optimized database queries using findByPk with minimal attributes
- **Chain Handling**: Implemented automatic skip for unsynchronized chains like Monero
- **Error Resilience**: Enhanced using Promise.allSettled() for better fault tolerance

### Support Ticket Management
- **Data Visibility**: Enhanced with direct ticket subject and customer detail display
- **Date Display**: Improved showing both date and time stamps
- **Field Priority**: Adjusted priority for important fields like subject and creation date

### API Endpoint Management
- **Real-time Updates**: Integrated real-time balance updates into master wallet index endpoint
- **Endpoint Consolidation**: Merged balance fetching into main wallet listing endpoint
- **Performance**: Eliminated need for separate balance API calls