# Version 5.1.6
**Release Date:** June 20, 2025  
**Tags:** MAJOR FEATURES, UI IMPROVEMENTS, SYSTEM ENHANCEMENTS

## Added

### Markdown Update Notes Rendering System
- **Intelligent Markdown Detection**: Added automatic detection and rendering for update notes in admin system and extension pages
- **MarkdownRenderer Component**: Created component with proper Tailwind CSS styling and dark mode support
- **Enhanced Display Formatting**: Proper formatting for headers, lists, bold text, links, and code blocks
- **Backward Compatibility**: Automatic detection between markdown and HTML content for existing notes
- **Comprehensive Conversion**: Markdown-to-HTML conversion with support for nested lists and inline formatting

### Automatic Update Checking on Page Load
- **System Update Automation**: Enhanced system update page to automatically check for updates when product info is loaded and license is verified
- **Extension Update Automation**: Updated extension details pages to automatically check for updates when extension is selected and license is verified
- **Store Integration**: Improved extension store to automatically trigger update checks after successful license verification
- **Intelligent Checking**: Added smart update checking that only runs when necessary conditions are met
- **Enhanced UX**: Eliminated manual "Check for Updates" button clicks for initial update status

### Mobile App Download Section for Home Page
- **Dynamic Section Display**: Added mobile app section that displays when app store or Google Play links are configured in settings
- **Professional Mockup**: Implemented mobile app mockup with animated phone frame and interactive trading dashboard
- **Authentic Download Buttons**: Added App Store and Google Play download buttons with authentic styling and hover effects
- **Feature Highlights**: Enhanced with feature highlights (Secure Trading, Lightning Fast, User Friendly) and gradient backgrounds
- **Settings Integration**: Integrated with settings configuration for easy management of download links from admin panel
- **Responsive Design**: Added proper responsive design with mobile-first approach and smooth animations
- **Modern Glass Effects**: Created comprehensive mobile app promotion section with modern glass-morphism design effects

### Mobile App Settings Configuration
- **App Store Links**: Added appStoreLink and googlePlayLink settings to social media configuration category
- **URL Validation**: Implemented URL validation for mobile app download links in admin settings panel
- **Default Configuration**: Added default empty values for new mobile app settings with proper type validation
- **Conditional Display**: Enhanced settings system to support conditional display of mobile app section based on configured links

### Dynamic Site Name Integration
- **P2P Platform Branding**: Replaced hardcoded "CryptoP2P" references with dynamic site name from environment configuration
- **Environment Integration**: P2P landing page now displays site name from NEXT_PUBLIC_SITE_NAME environment variable
- **Brand Consistency**: Enhanced branding consistency across P2P features to match site configuration

### Comprehensive Wallet Statistics Endpoint
- **Accurate Balance Calculations**: Created new wallet stats endpoint with accurate balance calculations using existing price utility functions
- **Multi-Currency Support**: Implemented proper USD conversion using price conversion functions
- **24-Hour Change Tracking**: Added 24-hour change calculations based on historical PnL data with percentage tracking and proper TypeScript typing
- **Wallet Metrics**: Enhanced wallet counting with total wallets and active wallets (balance > 0) metrics
- **Type Integration**: Integrated wallet statistics by type (FIAT, SPOT, ECO, FUTURES) with individual counts and balances
- **Real-time Updates**: Updated wallet store to automatically fetch and display real-time statistics
- **Enhanced Display**: Enhanced wallet stats component with proper currency formatting and active wallet indicators

### Cryptocurrency Icons in Market Page
- **Icon Integration**: Added real cryptocurrency icons to market page asset listings
- **Fallback System**: Implemented Image component with proper fallback to generic icon for missing icons
- **Visual Enhancement**: Enhanced icon container with circular borders and proper overflow handling
- **Design Consistency**: Improved visual consistency between home page live markets and market page listings

### Enhanced Email Template with Logo Integration
- **Logo Placeholder**: Added logo placeholder to email header with proper styling and responsive design
- **Header Enhancement**: Enhanced email header with site name and improved visual hierarchy
- **Visual Separation**: Added gradient accent bar to email content section for better visual separation
- **Logo Styling**: Improved logo styling with backdrop blur effects and subtle background for better visibility
- **Modern Design**: Enhanced email template responsiveness and modern design elements

### Installer Build Artifacts Cleanup System
- **Automatic Cleanup**: Added automatic cleanup of .next directory before build process to prevent permission denied errors
- **Comprehensive Removal**: Implemented comprehensive build artifacts removal
- **Manual Cleanup Option**: Added --clean-build command line option for manual cleanup of build artifacts
- **Permission Handling**: Enhanced permission handling function to include build artifacts cleanup
- **Error Handling**: Improved error handling for permission issues during build process with fallback cleanup methods

### Enhanced Installer Application Startup System
- **Proper Application Startup**: Improved installer to properly start application at installation completion
- **Startup Script Creation**: Enhanced startup script creation with proper user environment setup
- **Process Monitoring**: Added robust process monitoring with PID file tracking and health checks
- **Startup Verification**: Implemented comprehensive startup verification with connectivity tests and process validation
- **Error Handling**: Enhanced error handling and debugging information for failed startup attempts
- **Cleanup System**: Added automatic cleanup of temporary startup scripts and improved logging for troubleshooting
- **Permission Management**: Fixed user switching issues to ensure application runs with correct permissions and environment variables

## Fixed

### Binary Active Positions Header Display
- **Translation Fix**: Fixed binary active positions header showing "active_positions" instead of proper "Active Positions" title
- **Multilingual Support**: Updated translation key to display correctly formatted header text across all 57 supported languages

### Installer Permission Issues
- **Permission Denied Errors**: Fixed "Permission denied" errors when running pnpm commands as application user during installation
- **Script Access Issues**: Resolved temporary script access issues by creating scripts in application directory instead of /tmp
- **Environment Setup**: Enhanced pnpm setup with better path detection and user environment configuration
- **Error Handling**: Improved error handling and user access verification for Node.js tools

### Enhanced Database Import and File Permissions
- **SQL Import Fix**: Fixed SQL import issue that failed when database tables already exist from previous installations
- **Schema Checking**: Added intelligent database schema checking to skip import if tables are already present
- **File Permissions**: Implemented proper file permissions system with directories at 755 and files at 644 for security
- **Environment Security**: Enhanced .env file security with 600 permissions and proper ownership management
- **Permission Utility**: Added dedicated file permissions utility function for standalone permission repairs
- **Upload Directory**: Improved upload directory permissions with proper write access for web server
- **Command Options**: Added command-line options: --fix-permissions for permission repairs and --help for usage information

### Site Header Mobile Improvements
- **Menu Toggle Size**: Increased mobile menu toggle size for better accessibility
- **Icon Visibility**: Enhanced menu icon size for improved visibility
- **Authentication Buttons**: Fixed authentication buttons from confusing "In"/"Up" to proper "Login"/"Sign Up" text
- **Mobile Experience**: Improved responsive breakpoints and spacing for better mobile user experience

### Market Page Interface Complete Redesign
- **Search Input**: Redesigned search input with proper icon integration and consistent height styling
- **Filter Interface**: Converted cluttered filter buttons to professional dropdown menu with appropriate icons
- **Sorting Interface**: Completely overhauled sorting interface from ugly select element to professional dropdown menu
- **Sort Indicators**: Added visual sort direction indicators (↓/↑) and dedicated toggle option for ascending/descending order
- **Responsive Layout**: Enhanced responsive design with consistent layouts and consistent spacing
- **Mobile Optimization**: Improved mobile experience with full-width elements and proper visual hierarchy

## Enhanced

### Installer User Management and Application Startup
- **Security Enhancement**: Enhanced installer to run all pnpm commands as application user instead of root for better security
- **User Creation**: Automatically creates dedicated 'bicrypto' user when installer is run as root
- **Environment Setup**: Improved pnpm environment setup with proper PATH configuration for non-root users
- **Automatic Startup**: Added automatic application startup after installation completion with health checks
- **Systemd Service**: Created systemd service for automatic server restart and system boot startup
- **Startup Script**: Added comprehensive startup script with proper user switching and environment setup
- **Error Handling**: Enhanced installation process with better error handling and progress feedback
- **Ready-to-Use**: Application now starts automatically and is ready to use immediately after installation
- **Health Monitoring**: Added startup log monitoring and status verification with health checks
- **Permission Management**: Improved file permissions and ownership management throughout installation process

### Homepage Hero Section Layout Improvements
- **Spacing Optimization**: Further reduced spacing between "Trade Crypto" title and "Like a Pro" subtitle with negative margins for tighter visual hierarchy
- **Widget Balance**: Optimized live markets widget width to create better balance and focus on main content
- **Content Proportions**: Adjusted content proportions with left content taking 60% and market widget taking 40% of space
- **Visual Flow**: Enhanced visual flow and improved readability of the hero section elements
- **Icon Enhancement**: Fixed cryptocurrency icons to display properly in perfect circles with better sizing and overflow handling
- **Container Styling**: Improved icon container styling with proper border thickness and rounded appearance

### Site Header Professional Layout Redesign
- **Layout Redesign**: Redesigned header layout with improved spacing, alignment, and visual hierarchy for professional appearance
- **Logo Enhancement**: Enhanced logo container with gradient background and better proportions for brand consistency
- **Navigation Styling**: Improved navigation menu styling with modern rounded buttons and subtle hover effects
- **Controls Layout**: Optimized right-side controls layout with consistent spacing and better visual balance
- **Modern Effects**: Added proper borders and backdrop blur effects for enhanced depth and modern glass-morphism design
- **Mobile Integration**: Refined mobile menu integration and responsive behavior across all screen sizes
- **Accessibility**: Enhanced theme toggle and admin controls with improved visual feedback and accessibility

### Market Page Filtering and Sorting Layout
- **Responsive Design**: Improved responsive layout with better desktop/mobile breakpoints and flexible column system
- **Icon Spacing**: Reduced icon spacing in filter buttons on mobile and desktop
- **Button Layout**: Enhanced filter button layout with proper text sizing and whitespace handling for better wrapping
- **Search Section**: Optimized search and filter section with layout and better gap management
- **Sort Controls**: Added flex-shrink-0 to sort controls to prevent unwanted shrinking on smaller screens

### Email Template Professional Design Enhancement
- **Header Enhancement**: Enhanced email header with improved logo integration and visual hierarchy
- **Gradient Elements**: Added gradient accent elements and modern styling for better visual appeal
- **Content Spacing**: Improved content section padding and spacing for better readability
- **Responsive Design**: Enhanced responsive design for optimal display across all email clients
- **Footer Styling**: Added professional footer styling with proper social links and legal information 