import '../../domain/entities/futures_position_entity.dart';

class FuturesPositionModel {
  FuturesPositionModel({
    required this.id,
    required this.symbol,
    required this.side,
    required this.amount,
    required this.entryPrice,
    required this.markPrice,
    required this.leverage,
    required this.unrealisedPnl,
    required this.liquidationPrice,
    required this.createdAt,
  });

  final String id;
  final String symbol;
  final String side;
  final double amount;
  final double entryPrice;
  final double markPrice;
  final double leverage;
  final double unrealisedPnl;
  final double liquidationPrice;
  final DateTime createdAt;

  factory FuturesPositionModel.fromJson(Map<String, dynamic> json) {
    return FuturesPositionModel(
      id: json['id'].toString(),
      symbol: json['symbol'] ?? '',
      side: json['side'] ?? '',
      amount: (json['amount'] ?? 0).toDouble(),
      entryPrice: (json['entryPrice'] ?? 0).toDouble(),
      markPrice: (json['markPrice'] ?? 0).toDouble(),
      leverage: (json['leverage'] ?? 1).toDouble(),
      unrealisedPnl: (json['unrealisedPnl'] ?? 0).toDouble(),
      liquidationPrice: (json['liquidationPrice'] ?? 0).toDouble(),
      createdAt: DateTime.tryParse(json['createdAt']?.toString() ?? '') ??
          DateTime.now(),
    );
  }

  FuturesPositionEntity toEntity() => FuturesPositionEntity(
        id: id,
        symbol: symbol,
        side: side,
        amount: amount,
        entryPrice: entryPrice,
        markPrice: markPrice,
        leverage: leverage,
        unrealisedPnl: unrealisedPnl,
        liquidationPrice: liquidationPrice,
        createdAt: createdAt,
      );
}
