import 'package:json_annotation/json_annotation.dart';
import '../../domain/entities/pool_analytics_entity.dart';

part 'pool_analytics_model.g.dart';

/// Data model for pooling analytics fetched from API
@JsonSerializable(explicitToJson: true)
class PoolAnalyticsModel extends PoolAnalyticsEntity {
  const PoolAnalyticsModel({
    required String poolId,
    required String poolName,
    required String tokenSymbol,
    required double apr,
    required double totalStaked,
    required int totalStakers,
    required double totalEarnings,
    required List<Map<String, dynamic>> performanceHistory,
    required List<Map<String, dynamic>> stakingGrowth,
    required List<Map<String, dynamic>> withdrawals,
    required String timeframe,
  }) : super(
          poolId: poolId,
          poolName: poolName,
          tokenSymbol: tokenSymbol,
          apr: apr,
          totalStaked: totalStaked,
          totalStakers: totalStakers,
          totalEarnings: totalEarnings,
          performanceHistory: performanceHistory,
          stakingGrowth: stakingGrowth,
          withdrawals: withdrawals,
          timeframe: timeframe,
        );

  factory PoolAnalyticsModel.fromJson(Map<String, dynamic> json) =>
      _$PoolAnalyticsModelFromJson(json);

  Map<String, dynamic> toJson() => _$PoolAnalyticsModelToJson(this);
}
