# Ecosystem v5.2.0

**Release Date:** January 30, 2025
**Tags:** BUG FIXES, UTXO, EVM CHAINS, DEPOSIT SYSTEM

## Fixed

### UTXO & Bitcoin Ecosystem
- **Fixed** BTC deposits not saving UTXOs to database
- **Fixed** UTXO withdrawal unit conversion issues (satoshis vs BTC)
- **Fixed** BTC withdrawal failing with "Insufficient funds" error
- **Fixed** UTXO input amounts not converted to satoshis for calculations
- **Fixed** Change UTXO amounts properly converted back to standard units
- **Fixed** UTXO deposit monitoring verbose logging (reduced noise)

### Ethereum & EVM Chains
- **Fixed** ETH wallet creation validation errors
- **Fixed** Missing `address` field initialization in wallet creation
- **Fixed** Etherscan API V1 deprecation errors
- **Fixed** "Invalid raw transactions format" errors
- **Fixed** Missing `chainid` parameter for Etherscan V2 API
- **Fixed** EVM deposit monitoring errors for all Etherscan-based chains

## Improved

### UTXO System
- **Improved** UTXO saving on deposits for BTC, LTC, DOGE, DASH
- **Improved** UTXO withdrawal logic with proper unit conversions
- **Improved** Database storage consistency (always in standard units)
- **Improved** Calculation precision (always in satoshis)
- **Improved** UTXO deposit monitoring logging (only shows new transactions)

### API Migration
- **Improved** Migrated all Etherscan-based APIs to V2 endpoints
- **Improved** Added chainId parameter for all supported networks
- **Improved** Graceful error handling for deprecated V1 API responses
- **Improved** Better error logging with `[ETHERSCAN_API_ERROR]` prefix

### Wallet Management
- **Improved** Detailed error logging for wallet creation
- **Improved** Transaction parsing error messages with sample data
