# Version 5.5.9 - Investment, Forex, Payment & Internationalization Enhancements

**Release Date:** January 29, 2025

## Internationalization

### Menu Translation System
- **Added comprehensive menu translation support**
  - Created automated extraction script `tools/extract-menu-translations-v2.js`
  - Extracts all menu titles and descriptions from `frontend/config/menu.ts`
  - Generates translation keys in format: `menu.{key}.{field}`
  - Successfully extracted 180 translation keys (90 titles + 90 descriptions)
  - Added 16,110 translation keys across all 90 supported locales
  - Generated `tools/menu-translations.json` for reference

- **Translation Key Format**
  - Titles: `menu.admin.dashboard` → "Dashboard"
  - Descriptions: `menu.admin.dashboard.description` → Full description text
  - Nested items: `menu.admin.user.management` → "Users"
  - Consistent dot-notation for all menu levels

- **Implementation Ready**
  - All locale files updated with menu translation keys
  - English values added as base for all locales
  - Ready for translation via Translation Manager tool
  - Documentation created: `docs/MENU-TRANSLATION-IMPLEMENTATION.md`

- **Translation Manager Integration**
  - Added "Extract Menu Translations" button to Translation Manager UI
  - New API endpoint: `POST /api/tools-v2/extract-menu`
  - Status endpoint: `GET /api/tools-v2/menu-status`
  - Beautiful UI showing extraction statistics and next steps
  - One-click menu translation extraction from Tools tab
  - Real-time progress and detailed results display

- **Benefits**
  - Menus can now be fully localized to all 90 supported languages
  - Automated extraction makes adding new menu items easy
  - Consistent translation keys across the application
  - Fallback to English if translation missing
  - No need to leave Translation Manager to extract menu translations

## Payment Methods

### Custom Fields QR Code Support
- **Added QR Code option to deposit method custom fields**
  - QR Code option now appears in the Type dropdown when creating new deposit methods
  - Previously only available when editing existing methods
  - Updated CustomField type interface to include "qr" as valid type
  - Consistent with edit flow which already supported QR code upload
  - File: `frontend/components/blocks/data-table/drawers/form-controls/custom-fields.tsx`

## Investment Management

### Duration Selection for AI Investment & Forex Plans
- **Added multiselect duration field to AI Investment plans**
  - AI Investment plans can now select multiple durations when creating or editing
  - Added API endpoint `/api/admin/ai/investment/duration/options` for duration options
  - Durations display as tags similar to general investment plans

- **Added multiselect duration field to Forex plans**
  - Forex plans can now select multiple durations when creating or editing
  - Added API endpoint `/api/admin/forex/duration/options` for duration options
  - Changed duration field from non-editable tags to editable multiselect

- **Fixed duration saving error in AI Investment and Forex plans**
  - Previously: `notNull Violation: durationId: Duration ID cannot be null` error when saving
  - Root cause: Incorrect data mapping from multiselect component
  - Fixed: Updated duration data mapping to handle both string and object values
  - Now properly extracts duration IDs from multiselect component responses
  - Affected endpoints:
    - POST `/api/admin/ai/investment/plan`
    - PUT `/api/admin/ai/investment/plan/[id]`
    - POST `/api/admin/forex/plan`
    - PUT `/api/admin/forex/plan/[id]`

### General Investment Management Visibility
- **Fixed Investment Management section not appearing in Finance menu**
  - Removed `settings: ["investment"]` requirement from menu configuration
  - Investment Management is now a core feature, always visible to authorized users
  - Includes sub-sections:
    - Investment Plans
    - Investment Durations
    - Investment Analytics
  - Menu appears based on permissions only:
    - `access.investment.plan`
    - `access.investment.duration`
    - `access.investment`

## Forex Trading

### Account Type Display Fix
- **Fixed Forex account MT version always showing MT4**
  - Previously: Admin could set MT5, but trading page always loaded MT4
  - Root cause: MT version values sent as strings ("4", "5") instead of integers
  - Fixed: Admin form now sends proper integer values (4, 5)
  - Trading page iframe correctly uses selected MT version
  - Changed in admin Forex account columns:
    - MT4 option: `{ value: 4, label: "MT4" }`
    - MT5 option: `{ value: 5, label: "MT5" }`

## Technical Improvements

### API Endpoints Created
- `GET /api/admin/ai/investment/duration/options` - Returns available AI investment durations for multiselect
- `GET /api/admin/forex/duration/options` - Returns available Forex durations for multiselect

### Data Type Consistency
- **Duration mapping in plan endpoints**
  - Updated to handle both string and object types from multiselect component
  - Uses conditional check: `typeof duration === 'string' ? duration : duration.value`
  - Ensures compatibility with different data formats from frontend

- **MT version in Forex accounts**
  - Database expects INTEGER type for `mt` field
  - Frontend now sends integers instead of strings
  - Maintains data type consistency throughout the stack

### Database Models Referenced
- `aiInvestmentPlanDuration` - Junction table for AI investment plans and durations
- `forexPlanDuration` - Junction table for Forex plans and durations
- `forexAccount` - Stores MT version as INTEGER field

## Bug Fixes

### NFT Module
- **Fixed duplicate variable declaration in creator analytics**
  - Removed duplicate `creator` variable on line 88 of `nft/creator/analytics/index.get.ts`

- **Fixed syntax error with extra closing brace**
  - Corrected object structure in creator analytics return statement

- **Fixed invalid import in NFT listing**
  - Removed non-existent import: `import type { NFTListing } from "~~/types/models/nftModels"`

## Configuration Changes

### Menu Configuration (`frontend/config/menu.ts`)
- Removed settings restrictions from Investment Management section (line 269)
- Removed settings restrictions from Investment Plans (line 279)
- Removed settings restrictions from Investment Durations (line 289)
- Removed settings restrictions from Investment Analytics (line 299)

## Breaking Changes
None

## Migration Notes
- No database migrations required
- Existing AI Investment and Forex plans without durations will continue to work
- Admin can now add durations to existing plans through edit functionality

## Tested Components
- AI Investment plan creation with duration selection
- AI Investment plan editing with duration updates
- Forex plan creation with duration selection
- Forex plan editing with duration updates
- Forex account MT4/MT5 selection in admin
- Forex trading page MT version loading
- Investment Management menu visibility in Finance section
